function [PDF_data, PDF_fits] = FitPlot(r, pdf, binsize, params,i)
%  params(1) s Weibull
%  params(2) k Weibull
%  params(3) s Chi
%  params(4) k Chi
%  params(5) s
%  params(6) a
%  params(7) b
%  params(8) sigma
%  params(9) xi
%  params(10) mu

%  distribution parameters.
   s1    = params(1);
   d1    = params(2);
   s2    = params(3);
   d2    = params(4);
    s    = params(5);
    a    = params(6);
    b    = params(7);
   sigma = params(8);
   xi    = params(9);
   mu    = params(10);
%  Plot the fits.
   figure(200+i)
   set(gca,'fontsize',12)
   hold on

%  Plot the estimated PDF.
   plot(r,pdf,'*')

% Set up the horizontal axis.
   rmax = r(length(r)) + (r(2)-r(1))/2;
   rtmp = [0:5:rmax];

% Plot the Weibull PDF.
   Weibull = PDFWeibull(rtmp,[s1,d1]);
   plot(rtmp,Weibull,'--r')

%  Plot the Chi PDF.
   Chi = PDFChi(rtmp,[s2,d2]);
   plot(rtmp,Chi,'-k')

% Plot the LS PDF.
   LS = PDFLS(rtmp,[s,a,b]);
   plot(rtmp,LS,':b')

  disp(i)
%  Plot the general GEV PDF
   GEV = PDFGEV(rtmp, [sigma,xi,mu]);
   plot(rtmp,GEV,'-.g')

   PDF_data = [];
   PDF_data = [r, pdf];
   PDF_fits = [];
   PDF_fits = [rtmp', Weibull', Chi', LS', GEV'];
   
   xlabel('r (nm)');
   ylabel('p (normalized by sum pdf and bin size)');
   legend('data','GW','Chi','LS','GEV')
   tmp = [];
   tmp = [tmp, 'PDF for Experiment '];
   tmp = [tmp, int2str(i)];
   tmp = [tmp, ' (bin size = '];
   tmp = [tmp, int2str(binsize)];
   tmp = [tmp, 'nm)'];
   title(tmp);
   print('-dpsc2', ['figures/PDFFIT',int2str(i)])
   hold off
%   close all
  end
